/* (C) Brendan Macmillan 2003
	Free for commercial use only
*/

/* Note:
	JSX deals in "events", such as the start of an array, the end of an array,
	a primitive int value and so on.  When writing, each event is represented
	by a method call.  When reading, the next event is obtained by calling
	"next()", which returns an int which represents the event (see DataReaderI).
	The details of this event can be obtained from various "get" methods,
	(also in DataReaderI).

	The grammar of these events is the same as the "native" XML grammar
	for JSX.  Thus, you can see examples of the grammar just by looking at
	XML fragments generated by JSX; and the documentation of the XML grammar
	also documents the events.
*/


package JSX;	// same namespace as Reading side (TODO: own package?)
import java.io.IOException;



public interface DataWriterI {

	public void flush() throws IOException;
	public void close() throws IOException;

	public void openGraph(int major, int minor, String format) throws IOException;
	public void closeGraph() throws IOException;

	public void _reset() throws IOException;

	public void primitive(String fieldName, String type, String value) throws IOException;
	public void _null(String fieldName) throws IOException;




	public void _class(String fieldName, String className) throws IOException;

	public void reference(String fieldName, String idref) throws IOException;
	public void string(String fieldName, String id, String value) throws IOException;

	public void openArray(String fieldName, String id, String base, int dim, int length) throws IOException;
	public void closeArray() throws IOException;

	public void openCollection(String fieldName, String id, String className) throws IOException;
	public void closeCollection() throws IOException;

	public void openObject(String fieldName, String id, String className, String superclasses) throws IOException;
	public void closeObject() throws IOException;

	public void openDeclaredClass(String className) throws IOException;
	public void closeDeclaredClass() throws IOException;


	public void openDefault() throws IOException;
	public void closeDefault() throws IOException;
}
